#ifndef _DRV_TIMERMODULE_H
#define _DRV_TIMERMODULE_H
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ノㄧ计 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
/**
 * @brief timebase 秅戳砞竚
 * @attention 纐粄ㄏノfs =fsub, LIRC/LXT
 * @warning n=0/1
 */
#define SET_TIMEBASE_8MS(n)		    { _pscr = 0x03; _tb##n##c = 0x00;}
#define SET_TIMEBASE_16MS(n)		{ _pscr = 0x03; _tb##n##c = 0x01;}
#define SET_TIMEBASE_32MS(n)		{ _pscr = 0x03; _tb##n##c = 0x02;}
#define SET_TIMEBASE_62MS(n)		{ _pscr = 0x03; _tb##n##c = 0x03;}
#define SET_TIMEBASE_124MS(n)	    { _pscr = 0x03; _tb##n##c = 0x04;}
#define SET_TIMEBASE_250MS(n)	    { _pscr = 0x03; _tb##n##c = 0x05;}
#define SET_TIMEBASE_500MS(n)	    { _pscr = 0x03; _tb##n##c = 0x06;}
#define SET_TIMEBASE_1000MS(n)	    { _pscr = 0x03; _tb##n##c = 0x07;}
#define SET_TIMEBASE_ENABLE(n)	    { _tb##n##f = 0x00; _tb##n##e = 0x01; _tb##n##on = 1;}
#define SET_TIMEBASE_DISABLE(n)	    { _tb##n##on = 0;}

/*! 璸/璸计篈北*/
enum TimerCountCtr_t
{
    COUNTER_OFF,   //!<
    COUNTER_ON,    //!<
    COUNTER_PAUSE, //!<
};
/*! 璸/璸计篈北*/
enum TimerClock_t
{
    TIMECLOCK_FSYS_4 = 0x00,       //!<
    TIMECLOCK_FSYS = 0x10,         //!<
    TIMECLOCK_FH_16 = 0x20,        //!<
    TIMECLOCK_FH_64 = 0x30,        //!<
    TIMECLOCK_FSUB = 0x40,         //!<
    TIMECLOCK_PTCK_RISING = 0x60,  //!<
    TIMECLOCK_PTCK_FALLING = 0x70, //!<
};


#define SET_PTMn_COUNTER_OFF(n)     { _pt##n##on = 0;}
#define SET_PTMn_COUNTER_ON(n)      { _pt##n##on = 1; _pt##n##pau = 0;}
#define SET_PTMn_COUNTER_PAUSE(n)   { _pt##n##pau = 1;}

void Drv_PTMn_PWM_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count);
void Drv_PTMn_Timer_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count);
void Drv_PTMn_Ctr(unsigned char PTMn, enum TimerCountCtr_t Status);
#endif



